﻿/*
	VERSION:		1.7
	1.7		Removes all AsBroadcaster listeners after the "unload" event is broadcast
	1.6		Removes onUnload() after calling it in order to speed-up movieClip removal.  (onUnload() never needs to get called twice anyway)
	
	
	USAGE:
		#include "functions/callUnload.as"
		callUnload( my_mc );
		my_mc.removeMovieClip();
	
	WHAT IT'S FOR:
		This recursively calls EVERY unload function and unload event within the target and its children.
		"unload" functions and events don't always automatically fire, so this is used to force-fire them.
*/
callUnload = function( parent )
{
	for(var nam in parent)
	{// for:  all variables in parent
		var thisChild = parent[nam];
		
		if(thisChild instanceof MovieClip){
			reportedPath = String(eval(thisChild._target));
			actualPath = String(eval(parent._target))+"."+nam;
			if(reportedPath.indexOf(actualPath) != -1 )		// if:  paths match
				callUnload(thisChild);
		}
	}// for:  all variables in parent
	
	parent.onKillFocus(null);									// causes components to remove their internal listeners
	parent.dispatchEvent({type:"unload"});		// component unload event
	parent.broadcastMessage("unload");				// broadcaster unload event
	parent.unload();													// manual component unload()
	parent.onUnload();												// manual movieClip onUnload()
	delete parent.onUnload;										// remove this so that removeMovieClip() takes effect instantly  (it doesn't need to get called twice anyway)
	// remove common listeners just in case
	parent.removeEventListener("keyDown", parent);
	parent.removeEventListener("keyUp", parent);
	Key.removeListener(parent);
	Mouse.removeListener(parent);
	// remove all other listeners
	for(var L in parent._listeners){
		var thisListener = parent._listeners[L];
		parent.removeListener( thisListener );
		delete thisListener;
	}// for:  each listener
}// callUnload()